varying vec2 		texCoord;		// Center
uniform vec2		invSize;
uniform sampler2D 	depthTexture;

mat3 sobel_y = mat3( 
     1.0, 0.0, -1.0, 
     2.0, 0.0, -2.0, 
     1.0, 0.0, -1.0 
);

mat3 sobel_x = mat3( 
     1.0, 2.0, 1.0, 
     0.0, 0.0, 0.0, 
    -1.0, -2.0, -1.0 
);					
								
void	main()
{
	float depthDiff = -texture2D(depthTexture, texCoord).r;
    mat3 I;
    vec3 texel;
    for (int i=0; i<3; i++) 
	{
        for (int j=0; j<3; j++) 
		{
            I[i][j] = -texture2D(depthTexture, texCoord + vec2(i-1, j-1)*invSize).r;
        }
    }

    float gx = dot(sobel_x[0], I[0]) + dot(sobel_x[1], I[1]) + dot(sobel_x[2], I[2]); 
    float gy = dot(sobel_y[0], I[0]) + dot(sobel_y[1], I[1]) + dot(sobel_y[2], I[2]);

    float g = sqrt(pow(gx, 2.0)+pow(gy, 2.0));
	
    gl_FragColor = vec4(vec3(1.0 - (clamp(depthDiff - g,0.0,1.0))), 1.0);
}
